%% This code generates Figure 4.g-i and Figure 5 vlPFC
% Citation: Saleh F, Fakharian M & Ghazizadeh A "Stimulus presentation can enhance spiking irregularity across subcortical and cortical regions." 2021

clc;
clear;

names = {'SNR','vlPFC'};

fig = figure('Color', 'White','unit','normalized',...
    'position',[0 0 .3 1]);

llim = [1.3,3];
dlim = [0,.5];

for counter_name = 1:numel(names)
    
    % params and region selection
    clearvars -except counter_name names fig llim dlim
    name = names{counter_name};
    
    load(['Datasets/',name,'.mat'])
        
    switch(name)
        
        case('vlPFC')
            % pre and post time
            T = [-100,100];
            
            align = 0;
            
            params.kass_params.K = 20;
            
            % params
            params.t_start = -200;
            params.t_end = 800;
            params.bin_width = 200;
            params.slide = 50;
            
            cv_lim = [.4,.8];
            
        case('SNR')
            % pre and post time
            T = [-100,50];
            
            align = 0;
            
            % kass params
            kass_params.K = 20;
            
            % params
            params.t_start = -200;
            params.t_end = 800;
            params.bin_width = 200;
            params.slide = 50;
            
            cv_lim = [.27,.47];
    end
    
    load(['Analyzed/',name,'_Analyzed.mat']);

    bin_width = params.bin_width;
    
    red = [255, 35, 71]/255;
    blue = [0, 159, 199]/255;
    orange = [199, 96, 0]/255;
    skyblue = [0, 188, 236]/255;
    green = [0, 89, 3]/255;
    lightgreen = [163, 203, 56]/255;
    viol = [115, 0, 150]/255;
    pink = 	[217, 128, 250]/255;
    gray = 	.6*[1, 1, 1];
    
    n_row = 9;
    n_col = numel(names);
    
    num = counter_name;
    
    times = results.times - align;
    
    subplot(n_row,n_col,num)
    t_FR = results.rate.t - align;
    FR = results.rate.fr;
    plot(t_FR(1:length(FR)),FR,'black')
    xlim([times(1),times(end)])
    
    hold on;
    plotErrorbar(times,results.FR,results.FR_SE,gray);
    lim = ylim;
    plot([0,0],[0,100],'--black');
    ylim(lim)
    
    title(name)
    box off;
    
    subplot(n_row,n_col,[1,2,3]*n_col+num)
    
    rectangle('Position',[.7*bin_width,-10,.3*bin_width,20],...
        'FaceColor',.9*[1,1,1]);
    
    hl1 = plotErrorbar(results.FFvT.T, results.FFvT.pre.FF_mean,...
        results.FFvT.pre.FF_SE,blue);
    hold on;
    hl2 = plotErrorbar(results.FFvT.T, results.FFvT.post.FF_mean,...
        results.FFvT.post.FF_SE,orange);
    
    x = results.FFvT.T;
    
    plot(x,results.FFvT.inter_pre+x/bin_width*results.FFvT.sl_pre,'--',...
        'Color',blue);
    plot(x,results.FFvT.inter_post+x/bin_width*results.FFvT.sl_post,...
        '--','Color',orange);
    
    scatter(0,results.FFvT.inter_pre,'filled','CData',blue);
    scatter(0,results.FFvT.inter_post,'filled','CData',orange);
    
    errorbar(0,results.FFvT.inter_pre,results.FFvT.inter_pre_SE,...
        'Color',blue);
    errorbar(0,results.FFvT.inter_post,results.FFvT.inter_post_SE,...
        'Color',orange);
    
    ylim([dlim(counter_name),llim(counter_name)])
    xlabel('time-bin (ms)')
    
    Ta = T - align;
    
    legend([hl1, hl2],{['Pre Stim. (',num2str(Ta(1)),'ms)'],...
        ['Post Stim. (',num2str(Ta(2)),'ms)']},'Box','off',...
        'Location','southeast');
    
    subplot(n_row,n_col,[5,6]*n_col+num);
    set(gca,'colororder',[green;red])
    yyaxis left
    plotErrorbar(times,results.nBTV.kass,...
        results.nBTV.kass_SE,green);
    yyaxis right
    plotErrorbar(times,results.FF,...
        results.FF_SE,red);
    
    hold on
    lim = ylim;
    plot([0,0],[0,100],'--black');
    ylim(lim)
    xlim([times(1),times(end)])
    xticklabels({})
    
    
    subplot(n_row,n_col,[7,8]*n_col+num);
        set(gca,'colororder',[viol;0 0 1])
   % colororder([viol;0 0 1]);
    yyaxis left
    hl3 = plotErrorbar(times,results.nWTV.kass,...
        results.nWTV.kass_SE, viol);
    xlim([times(1),times(end)])
    yyaxis right
    plotErrorbar(times,results.cv2.cv2,results.cv2.cv2_SE,'b');
    hold on;
    ylim(cv_lim)
    xlim([times(1),times(end)])
    plot([0,0],[0,100],'--black');
    xlabel('time(ms)')
    
end